<?php include 'includes/tema/topo.php'; ?>

<style>
/* Estilos específicos para a linha de totais dinâmicos */
#totais-dinamicos {
    position: sticky;
    bottom: 0;
    z-index: 100;
    transition: all 0.3s ease;
}

/* Responsividade para dispositivos móveis */
@media (max-width: 767px) {
    #totais-dinamicos .row {
        flex-direction: column !important;
        align-items: flex-start !important;
        gap: 15px !important;
    }
    
    #totais-dinamicos .totais-valores {
        flex-direction: column !important;
        gap: 12px !important;
        margin-top: 10px !important;
        width: 100%;
    }
    
    #totais-dinamicos .totais-valores > div {
        justify-content: space-between;
        width: 100%;
        padding: 8px 12px;
        background: rgba(255,255,255,0.8);
        border-radius: 8px;
        border: 1px solid #e0e0e0;
    }
}

/* Melhorar contraste em telas pequenas */
@media (max-width: 576px) {
    #totais-dinamicos {
        padding: 15px 10px !important;
        font-size: 12px;
    }
    
    #totais-dinamicos .totais-valores span {
        font-size: 12px !important;
    }
}

/* Animação suave para os valores dos totais */
#total-vendas-filtrado, #total-pagamentos-filtrado, #diferenca-total-filtrado {
    transition: all 0.3s ease;
}

/* Efeito hover nos badges dos totais */
#totais-dinamicos .totais-valores > div:hover span[id*="total"] {
    transform: scale(1.05);
    box-shadow: 0 2px 8px rgba(0,0,0,0.15);
}

/* Garantir que a tabela tenha overflow controlado */
.dt-responsive {
    overflow-x: auto;
    position: relative;
}

/* Ajustar espaçamento do DataTable */
.dataTables_wrapper .dataTables_length,
.dataTables_wrapper .dataTables_filter,
.dataTables_wrapper .dataTables_info,
.dataTables_wrapper .dataTables_paginate {
    margin: 0.5em 0;
}

/* Melhorar visual dos inputs de busca no footer */
.footer-search-input {
    transition: all 0.3s ease;
    font-size: 12px !important;
}

.footer-search-input:focus {
    background-color: #fff3cd !important;
    border-color: #ffc107 !important;
    box-shadow: 0 0 0 0.2rem rgba(255, 193, 7, 0.25) !important;
}

/* Indicador visual para linhas filtradas */
#footer-search tbody tr.filtered-out {
    opacity: 0.5;
    transition: opacity 0.3s ease;
}

/* Melhorar visual da info do DataTable */
.dataTables_info {
    font-size: 13px;
    color: #6c757d;
    font-weight: 500;
}

/* Destaque para totais dinâmicos durante atualização */
#totais-dinamicos.updating {
    background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%) !important;
    border-color: #ffc107 !important;
}
</style>

<?

$acao = antiSQL($_GET['acao']);		
$idpedido = antiSQL($_GET['id_pedido']);
		
$Inserir = antiSQL($_POST['Inserir']);
$Alterar = antiSQL($_POST['Alterar']);
$Excluir = antiSQL($_GET['Excluir']);

$id_cliente = antiSQL($_POST['id_cliente']);	
$id_produto = antiSQL($_POST['id_produto']);
$data = antiSQL(date("d/m/Y"));
$hora = antiSQL(date("H:i"));		
$status = antiSQL($_POST['status']);			




$checa_pedidos = mysqli_query($conn,"SELECT * FROM pedidos ")->fetch_array(); 

if($checa_pedidos['id_cliente'] == $id_cliente){

    echo 'Já existe pedido cadastrado para este cliente';


}else{

if ($Inserir == "ok") {
mysqli_query($conn,"INSERT INTO pedidos (id_cliente,data,hora) VALUES ('$id_cliente','$data','$hora')");
header( 'Location: pedidos.php?cadastrado_sucesso=sim');
}

}		

if ($Alterar == "ok"){
mysqli_query($conn,"UPDATE pedidos SET id_cliente='$id_cliente',data='$data',hora='$hora' WHERE id=$idpedido");
	
header( 'Location: pedidos.php?alterado_sucesso=sim');
}

if ($Excluir == "ok") {	
    mysqli_query($conn,"DELETE FROM pedidos WHERE id=$idpedido");
    mysqli_query($conn,"ALTER TABLE pedidos AUTO_INCREMENT = 1");	
    header('Location: pedidos.php?deletado_sucesso=sim');
} 




?>

<section class="pc-container">
    <div class="pc-content">
        <!-- [ breadcrumb ] start -->
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0)">Menu</a></li>
                            <li class="breadcrumb-item" aria-current="page">
                                <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                                echo ucfirst(strtolower($pagina)); ?>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-12">
                        <div class="page-header-title">
                            <h2 class="mb-0">
                                <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                                echo ucfirst(strtolower($pagina)); ?>
                            </h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- [ breadcrumb ] end -->

            <? if ($acao == "Alterar") { 
             $sql = mysqli_query($conn,"SELECT * FROM pedidos WHERE id=$idpedido")->fetch_array(); 
             
             } ?>

            <? if ($acao != "") { ?>
            <div class="smart-wrap">
                <div class="smart-forms smart-container wrap-0">
                    <div class="form-header header-blue ">
                        <h4><i class="fa fa-calendar-o"></i> Pedidos  </h4>
                    </div><!-- end .form-header section -->



                    <form name="usuarios" id="usuarios" method="post" action="<?php echo $_SERVER['PHP_SELF']?>"
                        enctype="multipart/form-data">


                        <div class="form-body">


                            <div class="spacer-b30">
                                <div class="tagline"><span style="color: black"> Cliente</span></div><!-- .tagline -->
                            </div>

                            <div class="frm-row">
                                <div class="section colm colm4">
                                </div>
                                <div class="section colm colm4">
                                    <label class="field select prepend-icon">

                                        <select name="id_cliente" class="example-data-array smart-select2 select2-hidden-accessible" style="width:100%"
                                        tabindex="-1" aria-hidden="true">
                                        <option value="">Selecionar Cliente</option>
                                            <? $sqla = mysqli_query($conn,"SELECT * FROM usuarios ORDER BY id");
while ($coluna = mysqli_fetch_array($sqla)) { ?>

                                            <option value="<? echo $coluna[id]?>" <? if
                                                ($sql['id_cliente']==$coluna[id]) echo " selected" ; ?> >
                                                <span style="color: "><? echo $coluna[nome]?></span>
                                            </option>
                                            <? } ?>
                                        </select> <span class="field-icon"><i class="fa fa-user"></i></span> <b
                                            class="tooltip tip-right-top"><b>Selecione o <span
                                                    style="color:#6CF;">Cliente</span> Exemplo: <span
                                                    style="color:#6CF;"> Usuario </span></b></b> </label>
                                </div>
                            </div>










                        </div>




                        <div class="form-footer" align="center">
                            <input type="hidden" name="id_pedido" value="<?php echo $idpedido; ?>">
                            <input type="hidden" name="<?php echo $acao; ?>" value="ok">
                            <input type="submit" class="button btn-blue" name="Submit" value="<?php echo $acao; ?>">

                        </div>

                    </form>
                </div>
            </div>



            <div class="row page-titles">

<div class="col-md-7 align-self-center text-left">
    <div class="d-flex justify-content align-items-center">

        <button type="button" class="btn btn-primary d-lg-block m-l-15"
            onclick="location.href='<? $pagina = basename($_SERVER['PHP_SELF'], ''); echo $pagina; ?>';"><i
                class="fa fa-plus-circle"></i>
            Voltar</button>
    </div>
</div>
</div>


            <? } else { ?>


                <div style="clear: both;"></div>


<div class="col-sm-12">
    <div class="card">
        <div class="card-header">
            <h5>Tabela:
                <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                    echo ucfirst(strtolower($pagina)); ?>
            </h5>
            <small>Aqui você tem as opções de <b>cadastrar</b>,<b>editar</b>,<b>excluir</b> <span
                    style="color:red;">
                    <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                        echo ucfirst(strtolower($pagina)); ?><span>.</small>
        </div>
        <div class="card-body">
            <div class="dt-responsive table-responsive">

                <table id="footer-search" class="table table-striped table-bordered nowrap">                                <thead>
                                    <tr>
                                        <th style="width: 5%">N° </th>
                                        <th style="width: 25%;">Cliente</th>
                                        <th style="width: 15%;">Empresa</th>
                                        <th style="width: 11%;" >Vendas</th>
                                        <th style="width: 11%;color:green" >Pagamentos</th>
                                        <th style="width: 7%">Data</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead><tfoot>
                                    <tr>
                                        <th style="width: 5%">N° </th>
                                        <th style="width: 25%;">Cliente</th>
                                        <th style="width: 15%;">Empresa</th>
                                        <th style="width: 11%;" >Vendas</th>
                                        <th style="width: 11%;">Pagamentos</th>
                                        <th style="width: 7%">Data</th>
                                        <th>Ações</th>
                                    </tr>                                </tfoot><tbody>                                    <?
                                    // OTIMIZAÇÃO: Uma única query com JOINs para buscar todos os dados necessários
                                    $sqlpedidos = mysqli_query($conn,"
                                        SELECT 
                                            p.id,
                                            p.id_cliente,
                                            p.data,
                                            u.nome as cliente_nome,
                                            u.id_empresa,
                                            e.empresa as empresa_nome,
                                            COALESCE(v.total_vendas, 0) as total_vendas,
                                            COALESCE(f.total_pagamentos, 0) as total_pagamentos
                                        FROM pedidos p
                                        LEFT JOIN usuarios u ON p.id_cliente = u.id
                                        LEFT JOIN empresas e ON u.id_empresa = e.id
                                        LEFT JOIN (
                                            SELECT id_pedido, SUM(valor) as total_vendas 
                                            FROM vendas 
                                            GROUP BY id_pedido
                                        ) v ON p.id = v.id_pedido
                                        LEFT JOIN (
                                            SELECT id_pedido, SUM(valor) as total_pagamentos 
                                            FROM financeiro_clientes 
                                            GROUP BY id_pedido
                                        ) f ON p.id = f.id_pedido
                                        ORDER BY p.id ASC
                                    ");
                                    
                                    while ($pedidos = mysqli_fetch_array($sqlpedidos)) { 
                                        $total_vendas = floatval($pedidos['total_vendas']);
                                        $total_pagamentos = floatval($pedidos['total_pagamentos']);
                                        $diferenca = $total_vendas - $total_pagamentos;
                                    ?>                                    <tr>
                                        <td style="width: 5%"> 
                                            <? echo $pedidos['id']; ?>  
                                        </td>
                                        <td> 
                                            <a href="usuarios.php?acao=Alterar&id_usuario=<?php echo $pedidos['id_cliente'];?>">
                                                <?php echo $pedidos['cliente_nome']; ?>
                                            </a>
                                        </td>
                                        <td>
                                            <a href="empresas.php?acao=Alterar&id_empresas=<?php echo $pedidos['id_empresa'];?>">
                                                <?php echo $pedidos['empresa_nome']; ?>
                                            </a>
                                        </td><td style="width: 12%;" data-vendas="<?php echo $total_vendas; ?>">
                                            <?php echo 'R$ '.number_format($total_vendas, 2, "," , "." ); ?>
                                        </td>
                                        <td style="width: 7%" data-pagamentos="<?php echo $total_pagamentos; ?>">
                                            <?php echo 'R$ '.number_format($total_pagamentos, 2, "," , "." ); ?>
                                            
                                            <!-- Botão de Calculadora de ( + e - ) -->
                                            <i class="fa-solid fa-calculator-simple" data-toggle="tooltip" data-placement="top" title="" data-original-title="
                                                <?php 
                                                if ($total_pagamentos > $total_vendas) {
                                                    echo 'Tem Há Receber: R$ '.number_format(($total_pagamentos - $total_vendas), 2, "," , "." );
                                                } else {
                                                    echo 'Falta Pagar: R$ '.number_format($diferenca, 2, "," , "." );
                                                }
                                                ?>
                                            "></i>
                                        </td><td style="width: 7%">
                                            <? echo $pedidos['data']; ?>
                                        </td>                                        <td style="width: 40px;"> 
                                            <button type="button" class="btn waves-effect waves-light btn-outline-info" data-toggle="tooltip" data-placement="top" title="" data-original-title="Editar" aria-describedby="tooltip647345">
                                                <a href="?acao=Alterar&id_pedido=<?php echo $pedidos['id'];?>">
                                                    <i class="fa fa-edit" style="font-size:20px; color:#0A94E1"></i>
                                                </a>
                                            </button>

                                            <button type="button" class="btn btn-inverse-warning waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="" data-original-title="Vendas" aria-describedby="tooltip647345">
                                                <a href="vendas.php?id_pedido=<? echo $pedidos['id'];?>&id_cliente=<? echo $pedidos['id_cliente'];?>" target="_blank">
                                                    <i class="fa fa-ticket" style="font-size:20px; color:#E1740A"></i>
                                                </a>
                                            </button>

                                            <button type="button" class="btn btn-inverse-success waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="" data-original-title="Financeiro" aria-describedby="tooltip647345">
                                                <a href="financeiro_clientes.php?id_pedido=<? echo $pedidos['id'];?>&id_cliente=<? echo $pedidos['id_cliente'];?>" target="_blank">
                                                    <i class="fa fa-solid fa-badge-dollar" style="font-size:20px; color:#32CD32"></i>
                                                </a>
                                            </button>

                                            <button type="button" class="btn btn-inverse-danger waves-effect waves-light " data-toggle="tooltip" data-placement="top" title="" data-original-title="Excluir">
                                                <a href="?Excluir=ok&id_pedido=<? echo $pedidos['id']; ?>" onClick="return pergunta();">
                                                    <i class="fa fa-trash" style="font-size:20px; color:#C80306"></i>
                                                </a>
                                            </button>
                                        </td>
                                    </tr>
                                    <? } ?>                                </tbody>                            
                            </table>
                              <!-- Totais dinâmicos grudados à tabela -->
                            <div id="totais-dinamicos" style="
                                margin: 0; 
                                padding: 12px 15px; 
                                background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
                                border: 1px solid #dee2e6; 
                                border-top: 2px solid #007bff;
                                border-radius: 0 0 4px 4px;
                                box-shadow: 0 2px 4px rgba(0,0,0,0.1);
                                position: relative;
                                z-index: 10;
                            ">
                                <div class="row" style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 10px; margin: 0;">                                    <div style="font-weight: 600; color: #495057; font-size: 14px; display: flex; align-items: center;">
                                        <span style="margin-right: 8px; font-size: 16px;">📊</span>
                                        <span id="totais-label">Totais dos Dados Filtrados</span>
                                    </div>                                    <div class="totais-valores" style="display: flex; gap: 25px; flex-wrap: wrap; align-items: center;">
                                        <div style="display: flex; align-items: center; gap: 6px;">
                                            <span style="color:#99a832; font-weight: 600; font-size: 13px;">💰 Vendas:</span> 
                                            <span id="total-vendas-filtrado" style="font-weight: 700; color: #2c5f2d; background: #d4edda; padding: 2px 8px; border-radius: 12px; font-size: 13px;">R$ 0,00</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 6px;">
                                            <span style="color:#5ca832; font-weight: 600; font-size: 13px;">💳 Pagamentos:</span> 
                                            <span id="total-pagamentos-filtrado" style="font-weight: 700; color: #155724; background: #d1ecf1; padding: 2px 8px; border-radius: 12px; font-size: 13px;">R$ 0,00</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 6px;">
                                            <span style="color:#3266a8; font-weight: 600; font-size: 13px;">📈 Saldo:</span> 
                                            <span id="diferenca-total-filtrado" style="font-weight: 700; color: #004085; background: #cce7ff; padding: 2px 8px; border-radius: 12px; font-size: 13px;">R$ 0,00</span>
                                        </div>
                                    </div>
                                </div>                            </div><?
                           // CORREÇÃO: Primeiro calcular todos os totais
                           $sql_totais_completos = mysqli_query($conn,"
                               SELECT 
                                   (SELECT COALESCE(SUM(valor), 0) FROM vendas) as total_vendas_completo,
                                   (SELECT COALESCE(SUM(valor), 0) FROM financeiro_clientes) as total_pagamentos_completo,
                                   (
                                       SELECT COALESCE(SUM(v.total_vendas), 0) 
                                       FROM pedidos p
                                       LEFT JOIN (
                                           SELECT id_pedido, SUM(valor) as total_vendas 
                                           FROM vendas 
                                           GROUP BY id_pedido
                                       ) v ON p.id = v.id_pedido
                                   ) as total_vendas_por_pedidos,
                                   (
                                       SELECT COALESCE(SUM(f.total_pagamentos), 0) 
                                       FROM pedidos p
                                       LEFT JOIN (
                                           SELECT id_pedido, SUM(valor) as total_pagamentos 
                                           FROM financeiro_clientes 
                                           GROUP BY id_pedido
                                       ) f ON p.id = f.id_pedido
                                   ) as total_pagamentos_por_pedidos
                           ");
                           
                           $totais_completos = mysqli_fetch_array($sql_totais_completos);
                           $diferenca_completa = $totais_completos['total_vendas_completo'] - $totais_completos['total_pagamentos_completo'];
                             // CORREÇÃO: Calcular registros órfãos baseado na diferença real
                           $vendas_orfas_valor = $totais_completos['total_vendas_completo'] - $totais_completos['total_vendas_por_pedidos'];
                           $pagamentos_orfaos_valor = $totais_completos['total_pagamentos_completo'] - $totais_completos['total_pagamentos_por_pedidos'];
                           
                           // DEBUG: Forçar exibição para diagnóstico
                           $debug_vendas = $totais_completos['total_vendas_completo'];
                           $debug_vendas_pedidos = $totais_completos['total_vendas_por_pedidos']; 
                           $debug_pagamentos = $totais_completos['total_pagamentos_completo'];
                           $debug_pagamentos_pedidos = $totais_completos['total_pagamentos_por_pedidos'];
                           
                           // Contar registros órfãos para exibição
                           $vendas_orfas = mysqli_query($conn,"
                               SELECT COUNT(*) as total
                               FROM vendas v 
                               LEFT JOIN pedidos p ON v.id_pedido = p.id 
                               WHERE p.id IS NULL OR v.id_pedido = 0 OR v.id_pedido IS NULL
                           ");
                           $vendas_orfas_result = mysqli_fetch_array($vendas_orfas);
                           
                           $pagamentos_orfaos = mysqli_query($conn,"
                               SELECT COUNT(*) as total
                               FROM financeiro_clientes f 
                               LEFT JOIN pedidos p ON f.id_pedido = p.id 
                               WHERE p.id IS NULL OR f.id_pedido = 0 OR f.id_pedido IS NULL
                           ");
                           $pagamentos_orfaos_result = mysqli_fetch_array($pagamentos_orfaos);
                           
                           ?>
                             </div>
                        </div>
                    </div>
                </div>
                  <!-- Totais Gerais do Sistema (fora do card da tabela) -->
                <div class="col-sm-12 mt-3">
                    <div class="card <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'border-warning' : 'border-info'; ?>">
                        <div class="card-header <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'bg-warning text-dark' : 'bg-info text-white'; ?> py-2">
                            <h6 class="mb-0" style="font-size: 14px; font-weight: 600;">
                                <i class="fa fa-chart-line mr-2"></i>Totais Gerais do Sistema
                                <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                                <span class="badge badge-danger ml-2">⚠️ Registros Órfãos</span>
                                <?php else: ?>
                                <span class="badge badge-success ml-2">✅ Dados Íntegros</span>
                                <?php endif; ?>
                            </h6>
                        </div>
                        <div class="card-body py-3">
                            <div class="row">                                <div class="col-md-8">
                                    <div style="display: flex; gap: 25px; flex-wrap: wrap; align-items: center;">
                                        <div style="display: flex; align-items: center; gap: 8px;">
                                            <span style="color:#99a832; font-weight: 600;">💰 Total Vendas:</span>
                                            <span style="font-weight: 700; color: #2c5f2d; font-size: 16px;">
                                                <?php echo 'R$ '.number_format($totais_completos['total_vendas_completo'], 2, "," , "." ); ?>
                                            </span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 8px;">
                                            <span style="color:#5ca832; font-weight: 600;">💳 Total Pagamentos:</span>
                                            <span style="font-weight: 700; color: #155724; font-size: 16px;">
                                                <?php echo 'R$ '.number_format($totais_completos['total_pagamentos_completo'], 2, "," , "." ); ?>
                                            </span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 8px;">
                                            <span style="color:#3266a8; font-weight: 600;">📈 Saldo Total:</span>
                                            <span style="font-weight: 700; color: #004085; font-size: 16px;">
                                                <?php echo 'R$ '.number_format($diferenca_completa, 2, "," , "." ); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div><div class="col-md-4">
                                    <small style="color: #6c757d; line-height: 1.4;">
                                        <strong>Inclui todos os registros do sistema</strong><br>
                                        
                                        <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                                        <span style="color: #dc3545;">⚠️ Registros Órfãos Detectados:</span><br>
                                        <?php if($vendas_orfas_valor > 0): ?>
                                        • <strong>Vendas:</strong> <?php echo $vendas_orfas_result['total']; ?> registros 
                                        (R$ <?php echo number_format($vendas_orfas_valor, 2, "," , "." ); ?>)<br>
                                        <?php endif; ?>
                                        <?php if($pagamentos_orfaos_valor > 0): ?>
                                        • <strong>Pagamentos:</strong> <?php echo $pagamentos_orfaos_result['total']; ?> registros 
                                        (R$ <?php echo number_format($pagamentos_orfaos_valor, 2, "," , "." ); ?>)
                                        <?php endif; ?>
                                        <?php else: ?>
                                        <span style="color: #28a745;">✅ Nenhum registro órfão detectado</span><br>
                                        <small style="color: #999;">Todos os registros estão vinculados a pedidos válidos</small>
                                        <?php endif; ?>
                                    </small>
                                </div>
                            </div>                            
                            <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                            <div class="mt-2 pt-2 border-top">
                                <small style="color: #999; font-size: 12px;">
                                    <strong>📋 Totais apenas de Pedidos Válidos (sem órfãos):</strong><br>
                                    <span style="color:#99a832;">💰 Vendas:</span> R$ <?php echo number_format($totais_completos['total_vendas_por_pedidos'], 2, "," , "." ); ?>
                                    &nbsp;|&nbsp;
                                    <span style="color:#5ca832;">💳 Pagamentos:</span> R$ <?php echo number_format($totais_completos['total_pagamentos_por_pedidos'], 2, "," , "." ); ?>
                                    &nbsp;|&nbsp;
                                    <span style="color:#3266a8;">📈 Saldo:</span> R$ <?php echo number_format($totais_completos['total_vendas_por_pedidos'] - $totais_completos['total_pagamentos_por_pedidos'], 2, "," , "." ); ?>
                                </small>
                            </div>
                            <?php else: ?>
                            <div class="mt-2 pt-2 border-top">
                                <small style="color: #28a745; font-size: 12px;">
                                    <strong>✅ Todos os registros estão corretamente vinculados a pedidos válidos</strong>
                                </small>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>                
                <!-- Card de Debug/Auditoria (sempre visível para diagnóstico) -->
                <div class="col-sm-12 mt-3">
                    <div class="card <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'border-warning' : 'border-info'; ?>">
                        <div class="card-header <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'bg-warning text-dark' : 'bg-info text-white'; ?> py-2">
                            <h6 class="mb-0" style="font-size: 14px; font-weight: 600;">
                                <i class="fa fa-<?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'exclamation-triangle' : 'info-circle'; ?> mr-2"></i>
                                <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'Auditoria de Registros Órfãos' : 'Auditoria dos Dados (Debug)'; ?>
                                <button class="btn btn-sm btn-outline-<?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'dark' : 'light'; ?> float-right" type="button" data-toggle="collapse" data-target="#collapseOrfaos" aria-expanded="false" aria-controls="collapseOrfaos">
                                    <i class="fa fa-chevron-down"></i> Detalhes
                                </button>
                            </h6>
                        </div>
                        <div class="collapse" id="collapseOrfaos">
                            <div class="card-body py-3">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 style="color: #dc3545;">🔍 Análise dos Dados:</h6>
                                        <ul style="font-size: 13px; margin-bottom: 0;">
                                            <li><strong>Total Vendas Sistema:</strong> R$ <?php echo number_format($debug_vendas, 2, "," , "." ); ?></li>
                                            <li><strong>Vendas em Pedidos:</strong> R$ <?php echo number_format($debug_vendas_pedidos, 2, "," , "." ); ?></li>
                                            <li><strong>Diferença Vendas:</strong> R$ <?php echo number_format($vendas_orfas_valor, 2, "," , "." ); ?> 
                                                <?php if($vendas_orfas_valor > 0): ?>
                                                    <span style="color: #dc3545;">(<?php echo $vendas_orfas_result['total']; ?> registros órfãos)</span>
                                                <?php else: ?>
                                                    <span style="color: #28a745;">(✓ OK)</span>
                                                <?php endif; ?>
                                            </li>
                                            <hr style="margin: 10px 0;">
                                            <li><strong>Total Pagamentos Sistema:</strong> R$ <?php echo number_format($debug_pagamentos, 2, "," , "." ); ?></li>
                                            <li><strong>Pagamentos em Pedidos:</strong> R$ <?php echo number_format($debug_pagamentos_pedidos, 2, "," , "." ); ?></li>
                                            <li><strong>Diferença Pagamentos:</strong> R$ <?php echo number_format($pagamentos_orfaos_valor, 2, "," , "." ); ?>
                                                <?php if($pagamentos_orfaos_valor > 0): ?>
                                                    <span style="color: #dc3545;">(<?php echo $pagamentos_orfaos_result['total']; ?> registros órfãos)</span>
                                                <?php else: ?>
                                                    <span style="color: #28a745;">(✓ OK)</span>
                                                <?php endif; ?>
                                            </li>
                                        </ul>
                                        
                                        <div class="mt-3">
                                            <small style="color: #666; background: #f8f9fa; padding: 8px; border-radius: 4px; display: block;">
                                                <strong>🔧 Debug Info:</strong><br>
                                                Vendas órfãs calculadas: <?php echo $vendas_orfas_valor; ?><br>
                                                Pagamentos órfãos calculados: <?php echo $pagamentos_orfaos_valor; ?><br>
                                                Condição (valor > 0): <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'TRUE' : 'FALSE'; ?>
                                            </small>                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <h6 style="color: #856404;">⚙️ Status e Recomendações:</h6>
                                        
                                        <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                                        <div class="alert alert-warning py-2 mb-2">
                                            <strong>⚠️ Registros Órfãos Detectados</strong>
                                        </div>
                                        
                                        <h6 style="font-size: 12px; color: #dc3545; margin-bottom: 8px;">Possíveis Causas:</h6>
                                        <ul style="font-size: 12px; color: #6c757d; margin-bottom: 12px;">
                                            <?php if($vendas_orfas_valor > 0): ?>
                                            <li>Vendas com <code>id_pedido</code> nulo, zero ou inexistente</li>
                                            <li>Vendas criadas antes do pedido correspondente</li>
                                            <li>Pedidos deletados após criação das vendas</li>
                                            <?php endif; ?>
                                            <?php if($pagamentos_orfaos_valor > 0): ?>
                                            <li>Pagamentos com <code>id_pedido</code> nulo, zero ou inexistente</li>
                                            <li>Pagamentos criados antes do pedido correspondente</li>
                                            <li>Pedidos deletados após criação dos pagamentos</li>
                                            <?php endif; ?>
                                        </ul>
                                          <div style="background: #fff3cd; padding: 8px; border-radius: 4px; border-left: 3px solid #ffc107;">
                                            <small style="color: #856404;">
                                                <strong>💡 Recomendação:</strong> Verificar a integridade dos dados nas tabelas <code>vendas</code> e <code>financeiro_clientes</code>.
                                            </small>
                                        </div>
                                        
                                        <?php else: ?>
                                        <div class="alert alert-success py-2 mb-2">
                                            <strong>✅ Todos os Dados Estão Integros</strong>
                                        </div>
                                        
                                        <ul style="font-size: 12px; color: #28a745; margin-bottom: 12px;">
                                            <li>✓ Todas as vendas estão vinculadas a pedidos válidos</li>
                                            <li>✓ Todos os pagamentos estão vinculados a pedidos válidos</li>
                                            <li>✓ Não há registros órfãos no sistema</li>
                                        </ul>
                                          <div style="background: #d4edda; padding: 8px; border-radius: 4px; border-left: 3px solid #28a745;">
                                            <small style="color: #155724;">
                                                <strong>👍 Sistema OK:</strong> A integridade dos dados está mantida.
                                            </small>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            <div class="row page-titles">

<div class="col-md-3 align-self-center text-left">
    <div class="d-flex justify-content align-items-center">

        <button type="button" class="btn btn-primary d-lg-block m-l-15"
            onclick="location.href='?acao=Inserir';"><i class="fa fa-plus-circle"></i> Adicionar
            <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
echo ucfirst(strtolower($pagina)); ?>
        </button>
    </div>
</div>
</div>


<? } ?>

<!-- Search API (Regular Expressions) table end -->
</div>
</section>



<?php include 'includes/tema/base.php'; ?>

<script>
$(document).ready(function () {
    // Change selectboxes to selectize mode to be searchable
    $("select").select2();
    
    // Verificar se a tabela já foi inicializada e destruir se necessário
    if ($.fn.DataTable.isDataTable('#footer-search')) {
        $('#footer-search').DataTable().destroy();
    }      // Initialize DataTable com configuração melhorada
    var table = $('#footer-search').DataTable({
        dom: 'Blfrtip',
        mark: true,
        buttons: {
            name: 'primary',
            buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
        },
        "language": {
            "url": "datatable/pt-BR.json"
        },
        "pageLength": 25,
        "responsive": true,
        "processing": true,
        "info": true,
        "search": {
            "regex": true,
            "caseInsensitive": true
        },        "initComplete": function () {
            // Configurar busca no footer após inicialização completa
            setupFooterSearch();
            // Calcular totais iniciais com delay
            setTimeout(function() {
                calcularTotaisFiltrados();
                ajustarLayoutTotais();
                // Configurar observer para proteger mensagem de paginação
                configurarObserverPaginacao();
            }, 500);
        },        "drawCallback": function (settings) {
            // Recalcular totais sempre que a tabela for redesenhada (filtros, busca, paginação)
            setTimeout(function() {
                calcularTotaisFiltrados();
                ajustarLayoutTotais();
                
                // Reinicializar tooltips nas novas linhas
                $('[data-toggle="tooltip"]').tooltip('dispose').tooltip({
                    delay: { show: 300, hide: 100 }
                });
                
                // Reconfigurar observer de paginação após redraw
                configurarObserverPaginacao();
            }, 100);
        },"infoCallback": function(settings, start, end, max, total, pre) {
            // Personalizar a mensagem de informação para mostrar registros filtrados
            var filteredCount = settings.fnRecordsDisplay();
            var totalCount = settings.fnRecordsTotal();
            
            // DETECÇÃO MAIS ROBUSTA DE FILTROS ATIVOS
            var temFiltroAtivo = false;
            var motivoFiltro = [];
            
            // 1. Verificar busca global do DataTable
            try {
                var buscaGlobal = table.search();
                if (buscaGlobal && buscaGlobal.trim() !== '') {
                    temFiltroAtivo = true;
                    motivoFiltro.push('busca_global_api');
                }
            } catch (e) {
                console.log('⚠️ Erro ao verificar busca global via API:', e);
            }
            
            // 2. Verificar input de busca global diretamente no DOM
            var inputBuscaGlobal = $('.dataTables_filter input').val() || '';
            if (inputBuscaGlobal.trim() !== '') {
                temFiltroAtivo = true;
                motivoFiltro.push('busca_global_dom');
            }
            
            // 3. Verificar filtros por coluna (CORREÇÃO PRINCIPAL)
            try {
                if (table && table.columns) {
                    table.columns().every(function() {
                        if (this.search() && this.search().trim() !== '') {
                            temFiltroAtivo = true;
                            motivoFiltro.push('filtro_coluna');
                        }
                    });
                }
            } catch (e) {
                console.log('⚠️ Erro ao verificar filtros por coluna:', e);
            }
            
            // 4. Verificar inputs do footer (MAIS ESPECÍFICO)
            $('.footer-search-input').each(function() {
                if ($(this).val() && $(this).val().trim() !== '') {
                    temFiltroAtivo = true;
                    motivoFiltro.push('footer_input: ' + $(this).val());
                }
            });
            
            // 5. Verificar diferença entre registros exibidos e totais
            if (filteredCount !== totalCount) {
                temFiltroAtivo = true;
                motivoFiltro.push('diferenca_contagem');
            }
    
            console.log('📄 PAGINAÇÃO DEBUG:');
            console.log('  - Filtered Count:', filteredCount);
            console.log('  - Total Count:', totalCount);
            console.log('  - Busca Global:', inputBuscaGlobal);
            console.log('  - Tem Filtro Ativo:', temFiltroAtivo);
            console.log('  - Motivos:', motivoFiltro);
            
            // Gerar mensagem apropriada (CORRIGIDA)
            var mensagemFinal = '';
            if (!temFiltroAtivo || filteredCount === totalCount) {
                mensagemFinal = "Mostrando registros de " + start + " a " + end + " de um total de " + total + " registros";
            } else {
                if (filteredCount === 0) {
                    mensagemFinal = "Nenhum registro encontrado (filtrado de " + totalCount + " registros)";
                } else if (filteredCount === 1) {
                    mensagemFinal = "Mostrando 1 registro filtrado de um total de " + totalCount + " registros";
                } else {
                    // Para múltiplos registros filtrados
                    if (start === 1 && end === filteredCount) {
                        // Todos os registros filtrados estão na primeira página
                        mensagemFinal = "Mostrando " + filteredCount + " registros filtrados de um total de " + totalCount + " registros";
                    } else {
                        // Registros filtrados com paginação
                        mensagemFinal = "Mostrando registros de " + start + " a " + end + " de " + filteredCount + " registros filtrados (total: " + totalCount + " registros)";
                    }
                }
            }
            
            console.log('📄 InfoCallback retornando:', mensagemFinal);
            return mensagemFinal;
        }
    });

    // Função para ajustar layout dos totais em diferentes tamanhos de tela
    function ajustarLayoutTotais() {
        var $totais = $('#totais-dinamicos');
        var windowWidth = $(window).width();
        
        if (windowWidth < 768) {
            // Mobile: layout vertical
            $totais.find('.row').css({
                'flex-direction': 'column',
                'align-items': 'flex-start'
            });
            $totais.find('.totais-valores').css({
                'flex-direction': 'column',
                'gap': '10px',
                'margin-top': '10px'
            });
        } else {
            // Desktop: layout horizontal
            $totais.find('.row').css({
                'flex-direction': 'row',
                'align-items': 'center'
            });
            $totais.find('.totais-valores').css({
                'flex-direction': 'row',
                'gap': '25px',
                'margin-top': '0'
            });
        }
    }
    
    // Ajustar layout ao redimensionar janela
    $(window).resize(function() {
        setTimeout(ajustarLayoutTotais, 100);
    });    function setupFooterSearch() {
        // Aguardar um pouco para garantir renderização completa
        setTimeout(function() {
            console.log('🔧 SETUP FOOTER SEARCH - Iniciando...');
            
            // VERIFICAR SE JÁ EXISTEM INPUTS CRIADOS
            var $inputsExistentes = $('.footer-search-input');
            console.log('🔧 Inputs já existentes:', $inputsExistentes.length);
            
            if ($inputsExistentes.length > 0) {
                console.log('✅ Inputs já criados, pulando criação');
                return;
            }
            
            // TENTAR MÉTODO AUTOMÁTICO PRIMEIRO
            var inputsCriados = 0;
            table.columns().every(function (index) {
                var column = this;
                var title = $(column.footer()).text().trim();
                
                console.log('🔧 Processando coluna', index, '- título:', title);
                
                // Pular coluna de Ações (última coluna)
                if (index === 6) {
                    $(column.footer()).html('');
                    return;
                }
                
                if (title) {
                    try {
                        // Criar input com wrapper original
                        $(column.footer()).html('<div class="md-input-wrapper"><input type="text" class="md-form-control footer-search-input" placeholder="Buscar ' + title + '" data-column="' + index + '" /></div>');
                        inputsCriados++;
                        console.log('✅ Input criado para coluna', index, '(', title, ')');
                        
                        // Configurar evento de busca com delay para melhor performance
                        var searchTimeout;
                        $('input', column.footer()).on('keyup change clear', function () {
                            var searchValue = this.value;
                            var columnIndex = $(this).data('column');
                            
                            console.log('🔍 FILTRO COLUNA', columnIndex, ':', searchValue);
                            
                            // Limpar timeout anterior
                            clearTimeout(searchTimeout);
                            
                            // CORREÇÃO: Aplicar filtro com regex exata para busca
                            searchTimeout = setTimeout(function() {
                                if (column.search() !== searchValue) {
                                    console.log('🔍 APLICANDO FILTRO COLUNA', columnIndex, ':', searchValue);
                                    // Usar regex: false para busca simples (não regex)
                                    column.search(searchValue, false, false).draw();
                                    
                                    // Recalcular totais após busca
                                    setTimeout(function() {
                                        calcularTotaisFiltrados();
                                    }, 100);
                                }
                            }, 300);
                        });
                        
                        // Prevenir ordenação ao clicar no input
                        $('input', column.footer()).on('click', function(e) {
                            e.stopPropagation();
                        });
                        
                    } catch (error) {
                        console.log('❌ Erro ao criar input para coluna', index, ':', error);
                    }
                }
            });
            
            console.log('🔧 RESULTADO: Inputs criados automaticamente:', inputsCriados);
            
            // SE NÃO CONSEGUIU CRIAR AUTOMATICAMENTE, FORÇAR CRIAÇÃO MANUAL
            if (inputsCriados === 0) {
                console.log('⚠️ Método automático falhou, forçando criação manual...');
                criarInputsManualmente();
            } else {
                console.log('✅ Setup concluído com sucesso!');
            }
            
            // Configurar busca global com logs melhorados
            $('.dataTables_filter input').off('keyup.totais change.totais input.totais').on('keyup.totais change.totais input.totais', function() {
                var valorBusca = this.value;
                console.log('🔍 BUSCA GLOBAL DETECTADA:', valorBusca);
                
                setTimeout(function() {
                    calcularTotaisFiltrados();
                }, 300);
            });
            
            // Adicionar evento específico para o DataTable com logs
            table.on('search.dt', function() {
                console.log('🔍 EVENTO search.dt DISPARADO');
                setTimeout(function() {
                    calcularTotaisFiltrados();
                }, 200);
            });
            
            table.on('draw.dt', function() {
                console.log('🔍 EVENTO draw.dt DISPARADO');
                setTimeout(function() {
                    calcularTotaisFiltrados();
                }, 100);
            });
            
            // NOVO: Observador de mudanças mais agressivo para o input de busca
            var buscaInput = $('.dataTables_filter input')[0];
            if (buscaInput) {
                var observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (mutation.type === 'attributes' && mutation.attributeName === 'value') {
                            console.log('🔍 MUTAÇÃO DETECTADA no input de busca');
                            setTimeout(function() {
                                atualizarInfoPaginacao();
                            }, 300);
                        }
                    });
                });
                
                observer.observe(buscaInput, {
                    attributes: true,
                    attributeFilter: ['value']
                });
                
                // Adicionar também evento de input para captura em tempo real
                $(buscaInput).on('input propertychange', function() {
                    console.log('🔍 INPUT EVENT DETECTADO:', this.value);
                    setTimeout(function() {
                        atualizarInfoPaginacao();
                    }, 400);
                });
            }
            
            // NOVO: Observador para detectar se o DataTable está sobrescrevendo nossa modificação
            var infoElement = $('.dataTables_info')[0];
            if (infoElement) {
                var infoObserver = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (mutation.type === 'childList' || mutation.type === 'characterData') {
                            var textoAtual = $(infoElement).text();
                            console.log('📄 MUDANÇA DETECTADA na .dataTables_info:', textoAtual);
                            
                            // Se detectar que voltou ao texto padrão, reaplicar nossa customização
                            if (textoAtual.includes('de um total de 1666 registros') && !textoAtual.includes('filtrados')) {
                                var inputBusca = $('.dataTables_filter input').val() || '';
                                if (inputBusca.trim() !== '') {
                                    console.log('🔄 DataTable sobrescreveu, reaplicando customização...');
                                    setTimeout(function() {
                                        atualizarInfoPaginacao();
                                    }, 100);
                                }
                            }
                        }
                    });
                });
                
                infoObserver.observe(infoElement, {
                    childList: true,
                    characterData: true,
                    subtree: true
                });
            }// Inicializar tooltips após tudo carregado
            $('[data-toggle="tooltip"]').tooltip({
                delay: { show: 300, hide: 100 }
            });
        }, 300);
    }    function calcularTotaisFiltrados() {
        console.log('🚀 INICIANDO calcularTotaisFiltrados()');
        
        // Adicionar indicador visual de atualização
        $('#totais-dinamicos').addClass('updating');

        // DETECÇÃO MAIS PRECISA DE FILTRO ATIVO
        var valorBuscaInput1 = $('.dataTables_filter input').val() || '';
        var valorBuscaInput2 = $('input[type="search"]').val() || '';
        var valorBuscaInput3 = $('.dataTables_filter input[type="search"]').val() || '';
        var valorBuscaInput4 = $('#footer-search_filter input').val() || '';
        
        var valorBuscaInput = valorBuscaInput1 || valorBuscaInput2 || valorBuscaInput3 || valorBuscaInput4;
        var temBuscaNoInput = valorBuscaInput.trim() !== '';
        
        // Verificar filtros nas colunas do footer
        var temFiltroFooter = false;
        $('.footer-search-input').each(function() {
            if ($(this).val() && $(this).val().trim() !== '') {
                temFiltroFooter = true;
            }
        });
        
        // CORREÇÃO: Usar settings do DataTable para obter contagens corretas
        var settings = table.settings()[0];
        var linhasVisiveisCorretas = settings.fnRecordsDisplay(); // Registros após filtros
        var totalLinhasCorretas = settings.fnRecordsTotal(); // Total de registros
        var buscaGlobal = table.search();
        
        // Verificar filtros por coluna via API
        var temFiltroColuna = false;
        try {
            if (table && table.columns) {
                table.columns().every(function() {
                    if (this.search() && this.search().trim() !== '') {
                        temFiltroColuna = true;
                    }
                });
            }
        } catch (e) {
            console.log('⚠️ Erro ao verificar filtros por coluna:', e);
        }
        
        console.log('📊 DADOS CORRETOS:');
        console.log('  - Input busca global:', valorBuscaInput);
        console.log('  - Tem busca no input:', temBuscaNoInput);
        console.log('  - Tem filtro no footer:', temFiltroFooter);
        console.log('  - Tem filtro por coluna:', temFiltroColuna);
        console.log('  - Linhas filtradas (API):', linhasVisiveisCorretas);
        console.log('  - Total linhas:', totalLinhasCorretas);
        console.log('  - Busca global (API):', buscaGlobal);

        // CORREÇÃO PRINCIPAL: Só considerar filtrado se houver filtros REAIS aplicados
        var linhasVisiveisDOM = $('#footer-search tbody tr:visible').length;
        var totalLinhasDOM = $('#footer-search tbody tr').length;
        
        // NOVA LÓGICA: Só é filtro se tem busca/filtro aplicado OU se API mostra diferença
        var temFiltroRealAplicado = temBuscaNoInput || temFiltroFooter || temFiltroColuna || (linhasVisiveisCorretas < totalLinhasCorretas);
        
        console.log('🔍 Status do filtro CORRIGIDO:');
        console.log('  - Busca global ativa:', temBuscaNoInput);
        console.log('  - Filtro footer ativo:', temFiltroFooter);
        console.log('  - Filtro coluna ativo:', temFiltroColuna);
        console.log('  - API mostra filtro:', linhasVisiveisCorretas < totalLinhasCorretas);
        console.log('  - Linhas visíveis DOM:', linhasVisiveisDOM, 'Total:', totalLinhasDOM);
        console.log('  - TEM FILTRO REAL APLICADO:', temFiltroRealAplicado);

    if (!temFiltroRealAplicado) {
        // SEM FILTROS - Mostrar totais gerais
        console.log('📄 SEM FILTROS ATIVOS - Mostrando totais gerais');
        $('#totais-label').text('Totais Gerais dos Dados');
        
        setTimeout(function() {
            animarAtualizacaoValor('#total-vendas-filtrado', 'R$ ' + formatarValor(totaisCorretosPHP.vendas));
            animarAtualizacaoValor('#total-pagamentos-filtrado', 'R$ ' + formatarValor(totaisCorretosPHP.pagamentos));
            animarAtualizacaoValor('#diferenca-total-filtrado', 'R$ ' + formatarValor(totaisCorretosPHP.diferenca));
            $('#totais-dinamicos').removeClass('updating');
        }, 200);
        return;
    }

    // HÁ FILTROS ATIVOS - Calcular totais dos dados filtrados
    console.log('🎯 FILTROS ATIVOS - Calculando totais filtrados');
    
    // Usar contagem da API se disponível, senão usar DOM
    var registrosFiltrados = (linhasVisiveisCorretas < totalLinhasCorretas) ? linhasVisiveisCorretas : linhasVisiveisDOM;
    $('#totais-label').text('Totais dos Dados Filtrados (' + registrosFiltrados + ' de ' + totalLinhasCorretas + ' registros)');
    
    var totalVendas = 0;
    var totalPagamentos = 0;
    var contadorProcessado = 0;
    
    try {
        // TESTE SUPER SIMPLES PRIMEIRO
        console.log('🔬 TESTE SUPER SIMPLES - Contando linhas visíveis');
        
        var $linhasVisiveis = $('#footer-search tbody tr:visible');
        console.log('📊 Linhas visíveis encontradas:', $linhasVisiveis.length);
        
        // Se não encontrar linhas visíveis, o problema é na seleção
        if ($linhasVisiveis.length === 0) {
            console.log('⚠️ PROBLEMA: Nenhuma linha visível encontrada!');
            
            // Tentar seletores alternativos
            var alternativas = [
                '#footer-search tbody tr',
                '#footer-search tr',
                '.dataTables_wrapper tbody tr:visible',
                'table tbody tr:visible'
            ];
            
            for (var i = 0; i < alternativas.length; i++) {
                var seletor = alternativas[i];
                var $teste = $(seletor);
                console.log('🔍 Testando seletor "' + seletor + '":', $teste.length, 'elementos');
                
                if ($teste.length > 0) {
                    $linhasVisiveis = $teste;
                    console.log('✅ Usando seletor alternativo:', seletor);
                    break;
                }
            }
        }
        
        // Agora processar as linhas encontradas
        $linhasVisiveis.each(function(index) {
            contadorProcessado++;
            var $row = $(this);
            
            // Log detalhado apenas das primeiras 3 linhas para não sobrecarregar
            if (index < 3) {
                console.log('🔍 === LINHA', contadorProcessado, '(INDEX:', index, ') ===');
                
                // Mostrar texto completo da linha
                var textoCompleto = $row.text().replace(/\s+/g, ' ').trim();
                console.log('  📝 Texto completo:', textoCompleto);
                
                // Mostrar todas as células
                var $celulas = $row.find('td');
                console.log('  📋 Células encontradas:', $celulas.length);
                
                $celulas.each(function(cellIndex) {
                    var texto = $(this).text().trim();
                    var dataVendas = $(this).attr('data-vendas');
                    var dataPagamentos = $(this).attr('data-pagamentos');
                    
                    console.log('    📍 Célula', cellIndex, ':', {
                        texto: texto,
                        temRS: texto.includes('R$'),
                        dataVendas: dataVendas,
                        dataPagamentos: dataPagamentos
                    });
                });
            }
            
            // EXTRAÇÃO SIMPLIFICADA DE VALORES
            var vendas = 0;
            var pagamentos = 0;
            
            // Método 1: Data attributes (mais confiável)
            var vendasAttr = $row.find('td[data-vendas]').attr('data-vendas');
            var pagamentosAttr = $row.find('td[data-pagamentos]').attr('data-pagamentos');
            
            if (vendasAttr !== undefined && vendasAttr !== null && vendasAttr !== '') {
                vendas = parseFloat(vendasAttr) || 0;
            }
            if (pagamentosAttr !== undefined && pagamentosAttr !== null && pagamentosAttr !== '') {
                pagamentos = parseFloat(pagamentosAttr) || 0;
            }
            
            // Método 2: Se data-attributes não funcionaram, usar posição fixa
            if (vendas === 0 || pagamentos === 0) {
                var $celulas = $row.find('td');
                if ($celulas.length >= 6) {
                    // Vendas = coluna 4 (índice 3), Pagamentos = coluna 5 (índice 4)
                    var vendasTexto = $celulas.eq(3).text().trim();
                    var pagamentosTexto = $celulas.eq(4).text().trim();
                    
                    if (vendas === 0) vendas = extrairValorMonetario(vendasTexto);
                    if (pagamentos === 0) pagamentos = extrairValorMonetario(pagamentosTexto);
                }
            }
            
            // Log apenas das primeiras 3 linhas
            if (index < 3) {
                console.log('  💰 VALORES EXTRAÍDOS:');
                console.log('    Vendas:', vendas, '(de attr:', vendasAttr, ')');
                console.log('    Pagamentos:', pagamentos, '(de attr:', pagamentosAttr, ')');
                console.log('  ================================');
            }
            
            totalVendas += vendas;
            totalPagamentos += pagamentos;
        });
        
    } catch (error) {
        console.error('❌ Erro ao calcular totais filtrados:', error);
        console.error('Stack trace:', error.stack);
        
        // Fallback extremo: método de força bruta
        console.log('🆘 ATIVANDO FALLBACK EXTREMO');
        totalVendas = 0;
        totalPagamentos = 0;
        contadorProcessado = 0;
        
        // Buscar por QUALQUER elemento que contenha R$ na página
        $('*:contains("R$")').each(function() {
            var texto = $(this).text();
            if (texto.includes('R$') && !texto.includes('Totais') && !texto.includes('Sistema')) {
                var matches = texto.match(/R\$\s*[\d.,]+/g);
                if (matches) {
                    console.log('🆘 Elemento com R$ encontrado:', matches, 'em:', $(this)[0].tagName);
                }
            }
        });
    }
    
    console.log('📊 RESULTADO FINAL:');
    console.log('  - Linhas processadas:', contadorProcessado);
    console.log('  - Total Vendas:', totalVendas);
    console.log('  - Total Pagamentos:', totalPagamentos);
    console.log('  - Diferença:', totalVendas - totalPagamentos);
    
    var diferenca = totalVendas - totalPagamentos;

    // Atualizar elementos na página
    setTimeout(function() {
        animarAtualizacaoValor('#total-vendas-filtrado', 'R$ ' + formatarValor(totalVendas));
        animarAtualizacaoValor('#total-pagamentos-filtrado', 'R$ ' + formatarValor(totalPagamentos));
        animarAtualizacaoValor('#diferenca-total-filtrado', 'R$ ' + formatarValor(diferenca));
        $('#totais-dinamicos').removeClass('updating');
        
        // Atualizar paginação
        atualizarInfoPaginacao();
    }, 200);
}

// Adicionar função de debug manual para testar no console
window.debugTabelaManual = function() {
    console.log('=== DEBUG MANUAL DA TABELA ===');
    
    // Verificar se a tabela existe
    var $tabela = $('#footer-search');
    console.log('1. Tabela encontrada:', $tabela.length > 0);
    
    if ($tabela.length > 0) {
        var $tbody = $tabela.find('tbody');
        var $todasLinhas = $tbody.find('tr');
        var $linhasVisiveis = $tbody.find('tr:visible');
        
        console.log('2. Tbody encontrado:', $tbody.length > 0);
        console.log('3. Total de linhas:', $todasLinhas.length);
        console.log('4. Linhas visíveis:', $linhasVisiveis.length);
        
        // Testar primeira linha visível
        if ($linhasVisiveis.length > 0) {
            var $primeiraLinha = $linhasVisiveis.first();
            console.log('5. Primeira linha visível:');
            console.log('   Texto:', $primeiraLinha.text().trim());
            console.log('   HTML:', $primeiraLinha.html().substring(0, 200) + '...');
            
            var $celulas = $primeiraLinha.find('td');
            console.log('   Células:', $celulas.length);
            
            $celulas.each(function(i) {
                var texto = $(this).text().trim();
                var vendas = $(this).attr('data-vendas');
                var pagamentos = $(this).attr('data-pagamentos');
                
                console.log('   Célula ' + i + ':', {
                    texto: texto,
                    vendas: vendas,
                    pagamentos: pagamentos
                });
            });
        }
    }
    
    // Testar seletores alternativos
    console.log('6. Testando seletores alternativos:');
    var seletores = [
        'table tbody tr:visible',
        '.dataTables_wrapper tbody tr:visible', 
        '[id*="footer"] tbody tr:visible',
        'tbody tr:visible'
    ];
    
    seletores.forEach(function(seletor) {
        var elementos = $(seletor);
        console.log('   "' + seletor + '":', elementos.length, 'elementos');
    });
};

// Adicionar botão de debug na página
$(document).ready(function () {
    // Adicionar botão de debug após os totais com feedback visual
    $('#totais-dinamicos').after(`
        <div id="debug-container" style="margin: 10px; padding: 10px; background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 5px;">
            <button id="btn-debug" style="margin-right: 10px; padding: 5px 10px; background: #007bff; color: white; border: none; border-radius: 3px;">🔍 Debug Tabela</button>
            <button id="btn-force-calc" style="margin-right: 10px; padding: 5px 10px; background: #28a745; color: white; border: none; border-radius: 3px;">⚡ Forçar Cálculo</button>
            <button id="btn-test-filter" style="margin-right: 10px; padding: 5px 10px; background: #dc3545; color: white; border: none; border-radius: 3px;">🧪 Testar Filtro 2025</button>
            <div id="debug-output" style="margin-top: 10px; padding: 5px; background: white; border: 1px solid #ccc; font-family: monospace; font-size: 12px; max-height: 200px; overflow-y: auto;"></div>
        </div>
    `);
    
    function debugLog(message) {
        var timestamp = new Date().toLocaleTimeString();
        $('#debug-output').append('<div>[' + timestamp + '] ' + message + '</div>');
        $('#debug-output').scrollTop($('#debug-output')[0].scrollHeight);
    }
    
    // NOVO: Botão para testar filtro automaticamente
    $('#btn-test-filter').click(function() {
        $('#debug-output').html('');
        debugLog('=== TESTANDO FILTRO 2025 ===');
        
        // 1. Verificar se os inputs de filtro existem
        var $inputs = $('.footer-search-input');
        debugLog('1. Inputs de filtro encontrados: ' + $inputs.length);
        
        // 1.5 NOVO: Se não existem, forçar criação
        if ($inputs.length === 0) {
            debugLog('⚠️ Inputs não existem, forçando criação...');
            setupFooterSearch();
            
            // Aguardar criação
            setTimeout(function() {
                var $inputsNovos = $('.footer-search-input');
                debugLog('1.5. Inputs após forçar criação: ' + $inputsNovos.length);
                
                if ($inputsNovos.length > 0) {
                    // Mostrar detalhes dos inputs criados
                    $inputsNovos.each(function(i) {
                        var coluna = $(this).data('column');
                        var placeholder = $(this).attr('placeholder');
                        debugLog('   Input ' + i + ': coluna=' + coluna + ', placeholder="' + placeholder + '"');
                    });
                    
                    // Continuar com teste
                    testarFiltro2025();
                } else {
                    debugLog('❌ Ainda não conseguiu criar inputs!');
                    
                    // DIAGNÓSTICO: Verificar se footer existe
                    var $footer = $('#footer-search tfoot');
                    var $footerCells = $footer.find('th');
                    debugLog('   Footer existe: ' + ($footer.length > 0));
                    debugLog('   Células no footer: ' + $footerCells.length);
                    
                    // Tentar criar manualmente
                    debugLog('   Tentando criar input manualmente...');
                    var $dataCell = $footerCells.eq(5); // Coluna Data
                    if ($dataCell.length > 0) {
                        $dataCell.html('<div class="md-input-wrapper"><input type="text" class="md-form-control footer-search-input" placeholder="Buscar Data" data-column="5" /></div>');
                        debugLog('   ✅ Input criado manualmente!');
                        
                        // Configurar evento
                        var $inputManual = $dataCell.find('.footer-search-input');
                        $inputManual.on('keyup', function() {
                            var valor = this.value;
                            debugLog('   🔍 Filtro manual aplicado: "' + valor + '"');
                            table.column(5).search(valor).draw();
                        });
                        
                        // Aplicar filtro
                        setTimeout(function() {
                            testarFiltro2025();
                        }, 200);
                    } else {
                        debugLog('❌ Célula de Data não encontrada no footer!');
                    }
                }
            }, 500);
        } else {
            // Inputs já existem, continuar
            testarFiltro2025();
        }
    });
    
    // NOVA FUNÇÃO: Separar teste do filtro
    function testarFiltro2025() {
        var $inputData = $('.footer-search-input[data-column="5"]');
        debugLog('2. Input de Data encontrado: ' + ($inputData.length > 0));
        
        if ($inputData.length > 0) {
            // 3. Aplicar filtro "2025" automaticamente
            debugLog('3. Aplicando filtro "2025" na coluna Data...');
            $inputData.val('2025').trigger('keyup');
            
            setTimeout(function() {
                // 4. Verificar resultado após 1 segundo
                var settings = table.settings()[0];
                var filtradas = settings.fnRecordsDisplay();
                var total = settings.fnRecordsTotal();
                
                debugLog('4. RESULTADO DO FILTRO:');
                debugLog('   - Total registros: ' + total);
                debugLog('   - Registros filtrados: ' + filtradas);
                debugLog('   - Filtro funcionou: ' + (filtradas < total));
                
                // 5. Verificar se a tabela realmente filtrou
                var linhasVisiveis = $('#footer-search tbody tr:visible').length;
                debugLog('   - Linhas visíveis no DOM: ' + linhasVisiveis);
                
                // 6. Verificar conteúdo das primeiras linhas visíveis
                $('#footer-search tbody tr:visible').slice(0, 3).each(function(index) {
                    var data = $(this).find('td:eq(5)').text().trim();
                    debugLog('   - Linha ' + (index + 1) + ' data: "' + data + '"');
                });
                
                if (filtradas === total) {
                    debugLog('❌ FILTRO NÃO FUNCIONOU - Investigando...');
                    
                    // Verificar se o filtro foi aplicado na coluna
                    var filtroColuna = table.column(5).search();
                    debugLog('   - Filtro aplicado na coluna 5: "' + filtroColuna + '"');
                    
                    // Tentar aplicar filtro via API diretamente
                    debugLog('   - Tentando aplicar via API...');
                    table.column(5).search('2025').draw();
                    
                    setTimeout(function() {
                        var novoFiltradas = table.settings()[0].fnRecordsDisplay();
                        debugLog('   - Após API direta: ' + novoFiltradas + ' registros');
                        
                        if (novoFiltradas < total) {
                            debugLog('✅ FILTRO FUNCIONOU via API!');
                            calcularTotaisFiltrados();
                        } else {
                            debugLog('❌ Filtro ainda não funciona');
                        }
                    }, 500);
                } else {
                    debugLog('✅ FILTRO FUNCIONOU!');
                    calcularTotaisFiltrados();
                }
            }, 1000);
        } else {
            debugLog('❌ Input de Data ainda não encontrado!');
        }
    }

    $('#btn-debug').click(function() {
        $('#debug-output').html('');
        debugLog('=== INICIANDO DEBUG ===');
        
        var $tabela = $('#footer-search');
        var $tbody = $tabela.find('tbody');
        var $todasLinhas = $tbody.find('tr');
        var $linhasVisiveis = $tbody.find('tr:visible');
        
        debugLog('1. Tabela encontrada: ' + ($tabela.length > 0));
        debugLog('2. Total linhas: ' + $todasLinhas.length);
        debugLog('3. Linhas visíveis: ' + $linhasVisiveis.length);
        
        if ($linhasVisiveis.length > 0) {
            var $primeira = $linhasVisiveis.first();
            debugLog('4. Primeira linha texto: ' + $primeira.text().substring(0, 50) + '...');
            
            var $celulas = $primeira.find('td');
            debugLog('5. Células na primeira linha: ' + $celulas.length);
            
            // Verificar data-attributes das primeiras células
            for (var i = 0; i < Math.min(7, $celulas.length); i++) {
                var $celula = $($celulas[i]);
                var texto = $celula.text().trim();
                var vendas = $celula.attr('data-vendas');
                var pagamentos = $celula.attr('data-pagamentos');
                
                debugLog('   Célula ' + i + ': texto="' + texto.substring(0, 15) + '" vendas="' + vendas + '" pagamentos="' + pagamentos + '"');
            }
        }
        
        // Verificar se as funções necessárias existem
        debugLog('6. Função calcularTotaisFiltrados existe: ' + (typeof calcularTotaisFiltrados === 'function'));
        debugLog('7. Função extrairValorMonetario existe: ' + (typeof extrairValorMonetario === 'function'));
        debugLog('8. Variável table existe: ' + (typeof table !== 'undefined'));
        
        debugLog('=== DEBUG CONCLUÍDO ===');
    });
    
    $('#btn-force-calc').click(function() {
        $('#debug-output').html('');
        debugLog('=== FORÇANDO CÁLCULO MANUAL ===');
        
        var totalVendas = 0;
        var totalPagamentos = 0;
        var contador = 0;
        
        // Método super direto: pegar todas as linhas visíveis e extrair valores
        $('#footer-search tbody tr:visible').each(function() {
            contador++;
            var $linha = $(this);
            var textoCompleto = $linha.text();
            
            // Procurar por R$ no texto da linha
            var matches = textoCompleto.match(/R\$\s*[\d.,]+/g);
            
            if (matches && matches.length >= 2) {
                // Assumir que o primeiro R$ são vendas, segundo são pagamentos
                var vendas = extrairValorMonetarioSimples(matches[0]);
                var pagamentos = extrairValorMonetarioSimples(matches[1]);
                
                debugLog('Linha ' + contador + ': ' + vendas + ' + ' + pagamentos + ' (de: ' + matches.join(', ') + ')');
                
                totalVendas += vendas;
                totalPagamentos += pagamentos;
            } else {
                debugLog('Linha ' + contador + ': Nenhum valor R$ encontrado');
            }
        });
        
        debugLog('RESULTADO: Vendas=' + totalVendas + ', Pagamentos=' + totalPagamentos);
        
        // Atualizar interface
        $('#total-vendas-filtrado').text('R$ ' + totalVendas.toLocaleString('pt-BR', {minimumFractionDigits: 2}));
        $('#total-pagamentos-filtrado').text('R$ ' + totalPagamentos.toLocaleString('pt-BR', {minimumFractionDigits: 2}));
        $('#diferenca-total-filtrado').text('R$ ' + (totalVendas - totalPagamentos).toLocaleString('pt-BR', {minimumFractionDigits: 2}));
        
        debugLog('Interface atualizada!');
    });
    
    // Função de extração simplificada para teste
    function extrairValorMonetarioSimples(texto) {
        if (!texto) return 0;
        
        // Remover R$ e caracteres não numéricos, exceto vírgula e ponto
        var numerico = texto.replace(/R\$\s*/g, '').replace(/[^\d.,]/g, '');
        
               
        // Converter formato brasileiro para americano
        if (numerico.includes(',')) {
            numerico = numerico.replace(/\./g, '').replace(',', '.');
        }
        
        return parseFloat(numerico) || 0;
    }
    
});

// Simplificar a função calcularTotaisFiltrados para debug
function calcularTotaisFiltrados() {
    // Adicionar indicador visual de atualização
    $('#totais-dinamicos').addClass('updating');
    
    // USAR APENAS OS DADOS DA API DO DATATABLE
    var settings = table.settings()[0];
    var linhasVisiveisCorretas = settings.fnRecordsDisplay();
    var totalLinhasCorretas = settings.fnRecordsTotal();
    
    console.log('📊 CÁLCULO DOS TOTAIS:');
    console.log('  - Linhas filtradas:', linhasVisiveisCorretas);
    console.log('  - Total linhas:', totalLinhasCorretas);
    
    // CORREÇÃO: Verificar filtros de forma mais robusta
    var temFiltroRealAplicado = linhasVisiveisCorretas < totalLinhasCorretas;
    
    // Verificar também inputs de filtro MAIS ESPECÍFICO
    var temInputFiltro = false;
    var filtrosAtivos = [];
    $('.footer-search-input').each(function() {
        var valor = $(this).val();
        if (valor && valor.trim() !== '') {
            temInputFiltro = true;
            filtrosAtivos.push(valor);
        }
    });
    
    var buscaGlobal = $('.dataTables_filter input').val() || '';
    var temBuscaGlobal = buscaGlobal.trim() !== '';
    
    // VERIFICAR TAMBÉM VIA API DO DATATABLE
    var temFiltroViaAPI = false;
    try {
        table.columns().every(function() {
            if (this.search() && this.search().trim() !== '') {
                temFiltroViaAPI = true;
            }
        });
    } catch (e) {
        console.log('Erro ao verificar filtros via API:', e);
    }
    
    var temFiltroAtivo = temFiltroRealAplicado || temInputFiltro || temBuscaGlobal || temFiltroViaAPI;
    
    console.log('  - Tem filtro ativo:', temFiltroAtivo);
    console.log('  - Busca global:', buscaGlobal);
    console.log('  - Input filtro:', temInputFiltro);
    console.log('  - Filtros ativos:', filtrosAtivos);
    console.log('  - Filtro via API:', temFiltroViaAPI);
    
    if (!temFiltroAtivo) {
        // SEM FILTROS - Calcular todos os registros
        $('#totais-label').text('Totais Gerais dos Dados');
        
        var totalVendas = 0;
        var totalPagamentos = 0;
        
        table.rows().every(function() {
            var $row = $(this.node());
            var vendas = parseFloat($row.find('td[data-vendas]').attr('data-vendas')) || 0;
            var pagamentos = parseFloat($row.find('td[data-pagamentos]').attr('data-pagamentos')) || 0;
            totalVendas += vendas;
            totalPagamentos += pagamentos;
        });
        
        $('#total-vendas-filtrado').text('R$ ' + totalVendas.toLocaleString('pt-BR', {minimumFractionDigits: 2}));
        $('#total-pagamentos-filtrado').text('R$ ' + totalPagamentos.toLocaleString('pt-BR', {minimumFractionDigits: 2}));
        $('#diferenca-total-filtrado').text('R$ ' + (totalVendas - totalPagamentos).toLocaleString('pt-BR', {minimumFractionDigits: 2}));
        $('#totais-dinamicos').removeClass('updating');
        return;
    }

    // HÁ FILTROS ATIVOS - Calcular apenas os filtrados
    $('#totais-label').text('Totais dos Dados Filtrados (' + linhasVisiveisCorretas + ' de ' + totalLinhasCorretas + ' registros)');
    
    var totalVendas = 0;
    var totalPagamentos = 0;
    var contadorLinhas = 0;
    
    // MÉTODO DIRETO: usar API do DataTable para pegar apenas linhas filtradas
    table.rows({ filter: 'applied' }).every(function() {
        contadorLinhas++;
        var $row = $(this.node());
        
        // Pegar valores dos data-attributes
        var vendas = parseFloat($row.find('td[data-vendas]').attr('data-vendas')) || 0;
        var pagamentos = parseFloat($row.find('td[data-pagamentos]').attr('data-pagamentos')) || 0;
        
        totalVendas += vendas;
        totalPagamentos += pagamentos;
        
        // Log das primeiras 3 linhas para debug
        if (contadorLinhas <= 3) {
            console.log('  - Linha filtrada', contadorLinhas, ': vendas =', vendas, ', pagamentos =', pagamentos);
        }
    });
    
    console.log('  - Total Vendas Filtradas:', totalVendas);
    console.log('  - Total Pagamentos Filtrados:', totalPagamentos);
    console.log('  - Linhas processadas:', contadorLinhas);

    // Atualizar elementos na página
    setTimeout(function() {
        $('#total-vendas-filtrado').text('R$ ' + totalVendas.toLocaleString('pt-BR', {minimumFractionDigits: 2}));
        $('#total-pagamentos-filtrado').text('R$ ' + totalPagamentos.toLocaleString('pt-BR', {minimumFractionDigits: 2}));
        $('#diferenca-total-filtrado').text('R$ ' + (totalVendas - totalPagamentos).toLocaleString('pt-BR', {minimumFractionDigits: 2}));
        $('#totais-dinamicos').removeClass('updating');
    }, 200);
}

function extrairValorMonetario(texto) {
    if (!texto) return 0;
    
    // Converter para string e limpar
    var textoLimpo = texto.toString()
        .replace(/<[^>]*>/g, '')
        .replace(/&nbsp;/g, ' ')
        .replace(/\s+/g, ' ')
        .trim();
    
    // Extrair apenas a parte numérica
    var textoNumerico = textoLimpo
        .replace(/R\$\s*/g, '')
        .replace(/[^\d,.]/g, '')
        .trim();
    
    if (!textoNumerico) return 0;
    
    // Formato brasileiro: converter vírgula para ponto
    if (textoNumerico.includes(',')) {
        var partes = textoNumerico.split(',');
        if (partes.length === 2 && partes[1].length === 2) {
            var inteira = partes[0].replace(/\./g, '');
            var decimal = partes[1];
            return parseFloat(inteira + '.' + decimal) || 0;
        }
    }
    
    // Formato americano ou inteiro
    return parseFloat(textoNumerico) || 0;
}

// Adicionar funções auxiliares que faltam
function atualizarInfoPaginacao() {
    // Função placeholder
}

function configurarObserverPaginacao() {
    // Função placeholder
}

function animarAtualizacaoValor(seletor, valor) {
    $(seletor).text(valor);
}

function formatarValor(valor) {
    return parseFloat(valor || 0).toLocaleString('pt-BR', {minimumFractionDigits: 2});
}

}); // Fechar o $(document).ready principal

</script>

<script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>